//
//  MCWebViewTemplate.h
//  MCApplication
//
//  Created by Ali Lalani on 3/21/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCGenericActionHandler;
@interface MCWebViewTemplate : NSObject {
	NSString *_entityName;
	NSString *_applicableClassname;
	NSString *_html;
	NSString *_name;
	NSString *_description;
	NSString *_identifier;
	NSString *_path;
	NSString *_extension;
	
	BOOL openAllLinksExternally;
	
	NSNumber *_minimumHeight;
	NSNumber *_maximumHeight;
	
	NSArray  *_applicableEntityNames;
	id _actionHandler; // MCGenericActionHandler or subclass thereof
}
+ (MCWebViewTemplate *)templateForPath:(NSString *)aPath;
+ (MCWebViewTemplate *)quickUseTemplateForPath:(NSString *)aPath;

- (IBAction)refresh:(id)sender;


- (NSString *)entityName;
- (void)setEntityName:(NSString *)anEntityName;

- (NSString *)html;
- (void)setHtml:(NSString *)aHtml;

- (NSString *)name;
- (void)setName:(NSString *)aName;

- (NSString *)description;
- (void)setDescription:(NSString *)aDescription;

- (NSString *)identifier;
- (void)setIdentifier:(NSString *)anIdentifier;

- (NSString *)path;
- (void)setPath:(NSString *)aPath;

- (id)actionHandler;
- (void)setActionHandler:(id)anActionHandler;

- (NSString *)extension;
- (void)setExtension:(NSString *)anExtension;

- (NSNumber *)minimumHeight;
- (void)setMinimumHeight:(NSNumber *)aMinimumHeight;
- (NSNumber *)maximumHeight;
- (void)setMaximumHeight:(NSNumber *)aMaximumHeight;

- (NSArray *)applicableEntityNames;
- (void)setApplicableEntityNames:(NSArray *)anApplicableEntityNames;

- (NSString *)applicableClassname;
- (void)setApplicableClassname:(NSString *)anApplicableClassname;

- (BOOL)openAllLinksExternally;
- (void)setOpenAllLinksExternally:(BOOL)flag;
@end
